# Java Bird Game - Java 8 Web-Compatible Distribution

This is a **Java 8 compatible** distribution that works both as a standalone application and in web browsers via CheerpJ.

## What's Inside

- **bird-game.jar** - The game executable (compiled with Java 8)
- **runtime/** - Bundled Java Runtime Environment (no Java installation needed!)
- **lib/** - SQLite database library
- **sqlite.db** - Game database for high scores
- **index.html** - Web version launcher
- **run.bat** - Quick launcher for standalone desktop version
- **start-web.bat** - Starts local web server for browser version

## Running the Game

### Option 1: Standalone Desktop Version (Recommended)
Simply double-click **run.bat** to launch the game.

### Option 2: Web Browser Version
1. Double-click **start-web.bat**
2. The game will open in your default browser
3. **Keep the command window open** while playing
4. Close the window when done to stop the server

> **Note:** The web version requires an internet connection to load the CheerpJ runtime.

## Requirements

### Standalone Version
- **None!** Everything is included in this folder.

### Web Version
- Modern web browser (Chrome, Edge, or Firefox recommended)
- Internet connection (to load CheerpJ runtime)

## Technical Details

- **Java Version:** Compiled with Java 8 for maximum compatibility
- **Web Runtime:** CheerpJ 3.0 (Java-to-WebAssembly)
- **Database:** SQLite 3.7.2
- **Bundled JRE:** Custom runtime for standalone execution

## Why Java 8?

This distribution uses Java 8 because CheerpJ (the technology that runs Java in browsers) currently only supports Java 8. The standalone version works with any Java version via the bundled runtime.

---

**Enjoy the game!** 🐦
